import Checkbox from 'expo-checkbox';
import React, { useEffect, useRef, useState } from 'react';
import {
    Keyboard,
    KeyboardAvoidingView,
    Pressable,
    ScrollView,
    Text,
    TouchableOpacity,
    TouchableWithoutFeedback,
    View,
    StyleSheet,
    Dimensions,
    Platform
} from 'react-native';
import { RadioButton } from 'react-native-radio-buttons-group';
import { useDispatch, useSelector } from 'react-redux';
import ErrorIcon from '../../../../assets/svgs/errorIcon.svg';
import DeleteIcon from '../../../../assets/svgs/my wishlist/delete icon.svg';
import useAuth from '../../../../hooks/useAuth';
import {
    getMyAddress,
    getMyAddressWithoutLoading,
} from '../../../../redux/slices/user/address/getMyAddress';
import { postNewAddress } from '../../../../redux/slices/user/address/postNewAddress';
import BackNavigation from '../../../Utilities/CustomHeader/BackNavigation';
import CustomSpinner from '../../../Utilities/CustomSpinner/CustomSpinner';
import dpr from '../../../Utilities/CustomStyleAttribute/dpr';
import { EditProfileStyle } from '../../EditProfile/StyleEditProfile';
import { ProfileStyles } from '../../ProfileStyle';
import { addNewAddressStyle } from './AddNewAddressStyle';
import { mutation, query } from '../../../../redux/slices/util/apiRequest';
import useCustomToast from '../../../../hooks/useCustomToast';
import SelectItemBottomSheet from '../../../../src/components/SelectItemBottomSheet/SelectItemBottomSheet';
import SelectInput from '../../../../src/components/CustomInput/SelectInput/SelectInput';
import DownArrowFill from '../../../../assets/svgs/downArrowFill.svg';
import { getCountries } from '../../../../redux/slices/user/address/getCountries';
import { getStates } from '../../../../redux/slices/user/address/getStates';
import CustomSmallLoader from '../../../../src/components/CustomLoader/CustomSmallLoader';
import { getCity, resetCity } from '../../../../redux/slices/user/address/getCity';
import CustomTextInput from '../../../../src/components/CustomInput/CustomTextInput/CustomTextInput';
import {
    emailReg,
    isError,
    initErrorText,
    initialState,
    phoneReg,
    zipReg,
} from './initializeValue';
import { BASE_API_URL_STG } from '@env';
const { width } = Dimensions.get("screen");
import useLangTranslation from '../../../../hooks/useLangTranslation';
import CustomSVG from '../../../../src/components/CustomSVG/CustomSVG';
import { I18nManager } from 'react-native';
import usePreferences from '../../../../hooks/usePreferences';
import { getPreferences } from '../../../../redux/slices/preferences/getPreferences';
import { InOnScreenLoader } from '../../../ShoppingCart/ShoppingCart';

const URLGET = `${BASE_API_URL_STG}/user/addresses`;
const urlPost = `${BASE_API_URL_STG}/user/address/store`;
const urlPut = `${BASE_API_URL_STG}/user/address/update`;

const AddNewAddress = (props) => {
    const { trans } = useLangTranslation();
    const { address: addressPreference, loading: preferenceLoading  } = usePreferences();
    const { isUpdate, item, index = {} } = props.route.params || {};

    const { address_first_name_required, address_first_name_visible, address_last_name_required, address_last_name_visible, address_company_name_required, address_company_name_visible, address_phone_required, address_phone_visible, address_email_address_required, address_email_address_visible, address_type_of_place_required, address_type_of_place_visible, address_country_required, address_country_visible, address_state_required, address_state_visible, address_city_required, address_city_visible, address_zip_required, address_zip_visible, address_street_address_1_visible, address_street_address_1_required, address_street_address_2_visible, address_street_address_2_required } = addressPreference

    const { myAddresses } = useSelector((state) => state.getMyAddress);
    const { loading } = useSelector((state) => state.postNewAddress);
    const { countries, loading: countryLoading } = useSelector(
        (state) => state.getCountries
    );

    const { allState, loading: stateLoading } = useSelector(
        (state) => state.getStates
    );
    const { allCity, loading: cityLoading } = useSelector(
        (state) => state.getCity
    );

    const showToast = useCustomToast();
    const dispatch = useDispatch();
    const { access_token } = useAuth();

    const countrySelectRef = useRef(null);
    const [countryInfo, setCountryInfo] = useState(null);

    const stateSelectRef = useRef(null);
    const [stateInfo, setStateInfo] = useState(null);

    const citySelectRef = useRef(null);
    const [cityInfo, setCityInfo] = useState(null);

    const [deleteLoading, setDeleteLoading] = useState(false);
    const [address, setAddress] = useState(initialState);
    const [error, setError] = useState(isError);
    const [errorText, setErrorText] = useState(initErrorText);

    useEffect(() => {
        const countryInfoNew = countries?.find(
            (country) => country.iso2 == item?.country
        );
        setCountryInfo(countryInfoNew);
    }, [item?.country, countries])
    
    const firstNameRef = useRef(false);
    const lastNameRef = useRef(false);
    const companyNameRef = useRef(false);
    const emailRef = useRef(false);
    const phoneRef = useRef(false);
    const address1Ref = useRef(false);
    const address2Ref = useRef(false);
    const cityRef = useRef(false);
    const stateRef = useRef(false);
    const countryRef = useRef(false);
    const zipRef = useRef(false);
    const placeRef = useRef(false);

    const visibleFirstName = address_first_name_visible == "1";
    const visibleLastName = address_last_name_visible == "1";
    const visibleCompanyName = address_company_name_visible == "1";
    const visiblePhone = address_phone_visible == "1";
    const visibleEmailAddress = address_email_address_visible == "1";
    const visibleTypeOfPlace = address_type_of_place_visible == "1";
    const visibleCountry = address_country_visible == "1";
    const visibleState = address_state_visible == "1";
    const visibleCity = address_city_visible == "1";
    const visibleZip = address_zip_visible == "1";
    const visibleStreetAddress1 = address_street_address_1_visible == "1";
    const visibleStreetAddress2 = address_street_address_2_visible == "1";

    const requiredFields = {
        first_name: address_first_name_required == "1",
        last_name: address_last_name_required == "1",
        company_name: address_company_name_required == "1",
        phone: address_phone_required == "1",
        email: address_email_address_required == "1",
        type_of_place: address_type_of_place_required == "1",
        country: address_country_required == "1",
        state: address_state_required == "1",
        city: address_city_required == "1",
        zip: address_zip_required == "1",
        address_1: address_street_address_1_required == "1",
        address_2: address_street_address_2_required == "1",
    };

    const nameVisible = visibleFirstName && visibleLastName;
    const countryStateVisible = visibleCountry && visibleState;
    const cityZipVisible = visibleCity && visibleZip;

    useEffect(() => {
        let isMounted = true;
        if (isMounted) {
            dispatch(getPreferences());
        }
        if (isMounted && isUpdate) {
            const newItem = { ...item, is_default: item?.is_default };
            setAddress(newItem);
        }
        if (countries.length == 0) dispatch(getCountries(access_token));
        return () => {
            isMounted = false;
        };
    }, []);

    useEffect(() => {
        setError({
            ...error,
            city: cityRef.current,
            state: stateRef.current,
        });
        if (countryInfo?.id) {
            const stateUrl = `${BASE_API_URL_STG}/countries/${countryInfo?.id}/states`;
            dispatch(getStates({ stateUrl, access_token }));
            dispatch(resetCity());
        }
    }, [countryInfo?.id]);

    useEffect(() => {
        setError({
            ...error,
            city: cityRef.current,
        });
        if (stateInfo?.id) {
            const cityUrl = `${BASE_API_URL_STG}/countries/${countryInfo?.id}/states/${stateInfo?.id}/cities`;
            dispatch(getCity({ cityUrl, access_token }));
        }
    }, [stateInfo?.id]);

    const handleValidationError = () => {
        const fieldRefs = {
            first_name: firstNameRef,
            last_name: lastNameRef,
            company_name: companyNameRef,
            email: emailRef,
            phone: phoneRef,
            address_1: address1Ref,
            address_2: address2Ref,
            city: cityRef,
            country: countryRef,
            state: stateRef,
            zip: zipRef,
            type_of_place: placeRef,
        };

        const validationRules = {
            phone: (val) => val == '' || !phoneReg.test(address?.phone),
            email: (val) => val == '' || !emailReg.test(address?.email),
            address_1: (val) => val == '' || val.length >= 191,
            address_2: (val) => val == '' || val.length >= 191,
            default: (val) => val == '' || val == null,
        };

        Object.keys(fieldRefs).forEach((key) => {
            const isRequired = requiredFields[key];
            const value = address?.[key] ?? '';
            const validate = validationRules[key] || validationRules.default;
            fieldRefs[key].current = isRequired && validate(value);
        });

        setError((prevError) => ({
            ...prevError,
            ...Object.fromEntries(
                Object.entries(fieldRefs).map(([key, ref]) => [key, !!ref.current])
            ),
        }));
    };

    const handleAddressInfo = (name, text) => {
        if (name === "email" && emailReg.test(text) === false) {
            setError({
                ...error,
                [name]: true,
            });
            setErrorText({
                ...errorText,
                [name]: trans("Enter a valid email address"),
            });
        } else if (name === "phone" && phoneReg.test(text) === false) {
            setError({
                ...error,
                [name]: true,
            });
            setErrorText({
                ...errorText,
                [name]: trans("The phone number must be between 7 and 15 digits"),
            });
        } else if (name === "address_1" && text.length >= 191) {
            setError({
                ...error,
                [name]: true,
            });
            setErrorText({
                ...errorText,
                [name]: trans("The street address may not be greater than 191 characters."),
            });
        } else if (name === "zip" && zipReg.test(text) === false) {
            setError({
                ...error,
                [name]: true,
            });
            setErrorText({
                ...errorText,
                [name]: trans("Postcode only Number"),
            });
        } else {
            setError({
                ...error,
                [name]: false,
            });
            setErrorText({
                ...errorText,
                [name]: "",
            });
        }
        if (name === 'country') {
            setAddress({
                ...address,
                [name]: text,
                state: '',
                state_name: '',
                city: '',
            });
            setStateInfo(null);
            setCityInfo(null);
        } else if (name === 'state') {
            setAddress({ ...address, [name]: text, city: '' });
            setCityInfo(null);
        }
        else if (name === 'is_default') {
            setAddress({ ...address, [name]: Boolean(text) });
        } else {
            setAddress({
                ...address,
                [name]: trans(text),
            });
        }
    };
    const handleAddNewAddress = async () => {
        let URL = isUpdate ? urlPut : urlPost;
        address.is_default =
            myAddresses?.length === 0 ? 1 : address?.is_default ? 1 : 0;
        const missingField = Object.keys(requiredFields).find(
            (field) => requiredFields[field] && (!address?.[field] || error?.[field])
        );
        if (!missingField) {
            try {
                let newAdd = await dispatch(
                    postNewAddress({
                        access_token,
                        URL,
                        method: 'POST',
                        address,
                    })
                );
                let { code, message } = newAdd?.payload?.status;
                let records = newAdd?.payload?.records || {};
                if (code == 200 || code == 201) {
                    showToast({
                        text1: trans(message),
                        type: 'common',
                        position: 'bottom',
                        props: { variant: 'success' },
                    });
                    setAddress(initialState);
                    setError(isError);
                    setCountryInfo(null);
                    setStateInfo(null);
                    setCityInfo(null);
                    props.navigation.goBack();
                    dispatch(getMyAddress(access_token));
                } else {
                    showToast({
                        text1: trans(records[Object.keys(records)[0]][0]),
                        type: 'common',
                        position: 'bottom',
                        props: { variant: 'error' },
                    });
                }
            } catch (error) {
                showToast({
                    text1: trans("Something Went Wrong Please Try Again!"),
                    type: 'common',
                    position: 'bottom',
                    props: { variant: 'error' },
                });
            }
        } else {
            handleValidationError();
        }
    };

    const handleDeleteAddress = async (id) => {
        const DELETE_URL = `${BASE_API_URL_STG}/user/address/delete/${id}`;
        setDeleteLoading(true);
        const data = await mutation(DELETE_URL, 'DELETE', {}, access_token);
        if (data.response.records.length === 0) {
            let data = await query(URLGET, 'GET', access_token);
            const { status: { code } = {}, records } = data?.response;
            if (code === 200) {
                dispatch(getMyAddressWithoutLoading(records?.data));
                setDeleteLoading(false);
                props.navigation.goBack();
                showToast({
                    text1: trans("Address {{x}} has been deleted", { x: index + 1 }),
                    type: 'common',
                    position: 'bottom',
                    props: { variant: 'success' },
                });
            }
        }
    };

    const handleCountrySelect = (country) => {
        handleAddressInfo('country', country.iso2);
        setCountryInfo(country);
        setStateInfo(null);
        setCityInfo(null);
    };

    const handleStateSelect = (state) => {
        handleAddressInfo('state', state.iso2);
        setStateInfo(state);
        setCityInfo(null);
    };

    const handleCitySelect = (city) => {
        handleAddressInfo('city', city.name);
        setCityInfo(city);
    };

    const [fastLoad, setFastLoad] = useState(true);
    useEffect(() => setFastLoad(false), []);
    if (fastLoad) return <View />;

    const styles = Styles(error, address);

    const requiredError = Object.values(error).some(value => value === true);

    return (
        <>
            {preferenceLoading && <InOnScreenLoader />}
            <KeyboardAvoidingView
                style={styles.flex}
                behavior={Platform.OS === 'ios' ? 'padding' : ''}
            >
                <BackNavigation
                    navigationProps={props.navigation}
                    routeName={
                        isUpdate
                            ? trans("Address {{x}}", { x: index + 1 })
                            : trans("Add New Address")
                    }
                    capitalize={true}
                />
                <View style={ProfileStyles.hrLine} />
                <ScrollView
                    showsVerticalScrollIndicator={false}
                    keyboardShouldPersistTaps='always'
                >
                    <View style={addNewAddressStyle.container}>
                        <View style={nameVisible && EditProfileStyle.nameCont}>
                            {visibleFirstName && <CustomTextInput
                                label={`${trans("First Name")}${requiredFields?.first_name ? '*' : ''}`}
                                style={visibleLastName ? styles.firstNameInput : styles.textInput}
                                value={address?.first_name}
                                onChangeText={(text) =>
                                    handleAddressInfo('first_name', text)
                                }
                            />}
                            {visibleLastName && <CustomTextInput
                                label={`${trans('Last Name')}${requiredFields?.last_name ? '*' : ''}`}
                                style={[
                                    visibleFirstName ? styles.input : styles.textInput,
                                    EditProfileStyle.borderColor(error.last_name)
                                ]}
                                value={address?.last_name}
                                onChangeText={(text) =>
                                    handleAddressInfo('last_name', text)
                                }
                            />}
                        </View>
                        {visibleCompanyName && <CustomTextInput
                            label={`${trans('Company Name')}${requiredFields?.company_name ? '*' : ''}`}
                            style={[
                                styles.textInput,
                                EditProfileStyle.borderColor(error.company_name)
                            ]}
                            value={address?.company_name}
                            onChangeText={(text) =>
                                handleAddressInfo('company_name', text)
                            }
                        />}
                        {visibleEmailAddress && <CustomTextInput
                            label={`${trans('Email Address')}${requiredFields?.email ? '*' : ''}`}
                            style={[styles.textInput, styles.emailInput]}
                            value={address?.email}
                            onChangeText={(text) =>
                                handleAddressInfo('email', text)
                            }
                            keyboardType="email-address"
                            autoCapitalize="none"
                            error={(address?.email && error.email) ? errorText.email : null}
                        />}
                        {visiblePhone && <View>
                            <CustomTextInput
                                label={`${trans('Phone Number')}${requiredFields?.phone ? '*' : ''}`}
                                style={[styles.textInput, styles.phoneInput]}
                                value={address?.phone}
                                onChangeText={(text) =>
                                    handleAddressInfo('phone', text)
                                }
                                inputMode="tel"
                                error={(address?.phone && error.phone) ? errorText.phone : null}
                            />
                        </View>}
                        {visibleStreetAddress1 && <CustomTextInput
                            label={`${trans('Street Address 1')}${requiredFields?.address_1 ? '*' : ''}`}
                            style={[styles.textInput, styles.addressInput]}
                            value={address.address_1}
                            onChangeText={(text) =>
                                handleAddressInfo('address_1', text)
                            }
                            error={(address?.address_1 && error.address_1) ? errorText.address_1 : null}
                        />}
                        {visibleStreetAddress2 && <CustomTextInput
                            label={`${trans('Street Address 2')}${requiredFields?.address_2 ? '*' : ''}`}
                            style={[
                                styles.textInput,
                                EditProfileStyle.borderColor(error.address_2)]
                            }
                            value={address.address_2}
                            onChangeText={(text) =>
                                handleAddressInfo('address_2', text)
                            }
                        />}

                        <View style={countryStateVisible && EditProfileStyle.nameCont}>
                            {visibleCountry && <SelectInput
                                style={[
                                    visibleState ? addNewAddressStyle.dropdown1BtnStyle(error.country) : styles.textInput,
                                    !visibleState && EditProfileStyle.borderColor(error.country)
                                ]}
                                label={`${trans('Country')}${requiredFields?.country ? '*' : ''}`}
                                placeholder={trans('Select Country')}
                                onPress={() => {
                                    Keyboard.dismiss();
                                    countrySelectRef.current?.snapToIndex(0)
                                }
                                }
                                title={
                                    countryInfo?.name || address.country
                                }
                                icon={
                                    countryLoading ? (
                                        <CustomSmallLoader />
                                    ) : (
                                        <CustomSVG svgIcon={DownArrowFill} fill={'#2C2C2C'} />
                                    )
                                }
                            />}

                            {visibleState && <View style={visibleCountry && styles.ml15}>
                                <SelectInput
                                    style={[
                                        visibleCountry ? addNewAddressStyle.dropdown1BtnStyle(error.state) : styles.textInput,
                                        !visibleCountry && EditProfileStyle.borderColor(error.state)
                                    ]}
                                    label={`${trans('State')} / ${trans('Province')}${requiredFields?.state ? '*' : ''}`}
                                    placeholder={trans('Select State')}
                                    onPress={() =>
                                        stateSelectRef.current?.snapToIndex(0)
                                    }
                                    title={
                                        stateInfo?.name || address.state_name
                                    }
                                    icon={
                                        stateLoading ? (
                                            <CustomSmallLoader />
                                        ) : (
                                            <CustomSVG svgIcon={DownArrowFill} fill={'#2C2C2C'} />
                                        )
                                    }
                                />
                            </View>}
                        </View>
                        <View style={cityZipVisible && EditProfileStyle.nameCont}>
                            {visibleCity && <SelectInput
                                style={[
                                    visibleZip ? styles.input : styles.textInput,
                                    visibleZip ? styles.cityInput : EditProfileStyle.borderColor(error.city)
                                ]}
                                label={`${trans('City')}${requiredFields?.city ? '*' : ''}`}
                                placeholder={trans('Select City')}
                                onPress={() =>
                                    citySelectRef.current?.snapToIndex(0)
                                }
                                title={cityInfo?.name || address.city}
                                icon={
                                    cityLoading ? (
                                        <CustomSmallLoader />
                                    ) : (
                                        <CustomSVG svgIcon={DownArrowFill} fill={'#2C2C2C'} />
                                    )
                                }
                            />}
                            {visibleZip && <CustomTextInput
                                label={`${trans('Postcode')} / ${trans('ZIP')}${requiredFields?.zip ? '*' : ''}`}
                                style={[
                                    visibleCity ? EditProfileStyle.nameInput : styles.textInput,
                                    visibleCity ? styles.zipInput : EditProfileStyle.borderColor(error.zip)
                                ]}
                                value={address.zip}
                                onChangeText={(text) =>
                                    handleAddressInfo('zip', text)
                                }
                                keyboardType='numeric'
                                error={(address.zip && error.zip) ? errorText.zip : null}
                            />}
                        </View>
                        {visibleTypeOfPlace && <View>
                            <Text style={EditProfileStyle.label}>
                                {trans('Type of Place')}{requiredFields?.type_of_place ? '*' : ''}
                            </Text>
                            <View style={EditProfileStyle.radioCont}>
                                <RadioButton
                                    id='home'
                                    label={trans('Home')}
                                    size={16}
                                    selected={
                                        address.type_of_place === 'home'
                                            ? true
                                            : false
                                    }
                                    color={
                                        address.type_of_place === 'home'
                                            ? '#2C2C2C'
                                            : '#DFDFDF'
                                    }
                                    containerStyle={[EditProfileStyle.radioButton, styles.homeRadioButtonContainer]}
                                    labelStyle={[EditProfileStyle.radioText, styles.homeRadioButtonText]}
                                    onPress={(value) =>
                                        handleAddressInfo(
                                            'type_of_place',
                                            value
                                        )
                                    }
                                />
                                <RadioButton
                                    id='office'
                                    label={trans('Office')}
                                    size={16}
                                    selected={
                                        address?.type_of_place === 'office'
                                            ? true
                                            : false
                                    }
                                    color={
                                        address?.type_of_place === 'office'
                                            ? '#2C2C2C'
                                            : '#DFDFDF'
                                    }
                                    containerStyle={[
                                        EditProfileStyle.radioButton,
                                        styles.officeRadioButtonContainer
                                    ]}
                                    labelStyle={[
                                        EditProfileStyle.radioText,
                                        styles.officeRadioButtonText,
                                    ]}
                                    onPress={(value) =>
                                        handleAddressInfo(
                                            'type_of_place',
                                            value
                                        )
                                    }
                                />
                            </View>
                        </View>}
                        {myAddresses.length > 0 && (
                            <TouchableWithoutFeedback
                                disabled={item?.is_default ? true : false}
                                onPress={() =>
                                    handleAddressInfo(
                                        'is_default',
                                        !address?.is_default ? true : false
                                    )
                                }
                            >
                                <View style={addNewAddressStyle.default}>
                                    <Checkbox
                                        disabled={
                                            item?.is_default ? true : false
                                        }
                                        style={addNewAddressStyle.defaultIcon}
                                        value={
                                            address?.is_default
                                                ? true
                                                : false
                                        }
                                        onValueChange={() => {
                                            handleAddressInfo(
                                                'is_default',
                                                address.is_default
                                                    ? false
                                                    : true
                                            );
                                        }}
                                    />
                                    <Text
                                        style={addNewAddressStyle.defaultText}
                                    >
                                        {trans("Use as default Address in the future")}
                                    </Text>
                                </View>
                            </TouchableWithoutFeedback>
                        )}
                        {isUpdate && !item?.is_default && (
                            <View>
                                <Pressable
                                    onPress={() => {
                                        return deleteLoading
                                            ? {}
                                            : handleDeleteAddress(address?.id);
                                    }}
                                    style={addNewAddressStyle.deleteAddress}
                                    disabled={item?.is_default ? true : false}
                                >
                                    {deleteLoading ? (
                                        <CustomSpinner
                                            filePath={require('../../../../assets/lottie/loader.json')}
                                            size={{
                                                width: dpr(60),
                                                height: dpr(50),
                                            }}
                                        />
                                    ) : (
                                        <View
                                            style={
                                                addNewAddressStyle.deleteAddressBtn
                                            }
                                        >
                                            <View
                                                style={
                                                    addNewAddressStyle.deleteAddressBtnCont
                                                }
                                            >
                                                <CustomSVG svgIcon={DeleteIcon}
                                                    height={dpr(16)}
                                                    width={dpr(18)}
                                                    fill={'#FFFFFF'}
                                                />
                                                <Text
                                                    style={
                                                        addNewAddressStyle.deleteAddressBtnText
                                                    }
                                                >
                                                    {trans("Delete this Address")}
                                                </Text>
                                            </View>
                                        </View>
                                    )}
                                </Pressable>
                            </View>
                        )}
                    </View>
                </ScrollView>
                <View>
                    {requiredError ? (
                        <View style={EditProfileStyle.errorCont}>
                            <CustomSVG svgIcon={ErrorIcon} />
                            <Text style={EditProfileStyle.errorText}>
                                {trans('Please fill in all the required fields')}
                            </Text>
                        </View>
                    ) : null}
                </View>
                <View style={EditProfileStyle.changeInfo}>
                    <TouchableOpacity onPress={() => props.navigation.goBack()}>
                        <Text style={EditProfileStyle.cancel}>
                            {trans('Cancel')}
                        </Text>
                    </TouchableOpacity>
                    <Pressable
                        onPress={() => (loading ? {} : handleAddNewAddress())}
                    >
                        <View style={addNewAddressStyle.saveAddressCont}>
                            {loading ? (
                                <CustomSpinner
                                    filePath={require('../../../../assets/lottie/loader2.json')}
                                    size={{
                                        width: dpr(60),
                                        height: dpr(50),
                                    }}
                                />
                            ) : (
                                <Text style={addNewAddressStyle.saveAddressBtn}>
                                    {trans('Save Address')}
                                </Text>
                            )}
                        </View>
                    </Pressable>
                </View>
            </KeyboardAvoidingView>
            <SelectItemBottomSheet
                selectRef={countrySelectRef}
                data={countries}
                name={'country'}
                onPress={handleCountrySelect}
                loading={countryLoading}
                isHeaderComponent={true}
                snapPoint={[300, '100%']}
            />
            <SelectItemBottomSheet
                selectRef={stateSelectRef}
                data={allState}
                name={'state'}
                onPress={handleStateSelect}
                loading={stateLoading}
                isHeaderComponent={true}
                snapPoint={[300, '100%']}
            />
            <SelectItemBottomSheet
                selectRef={citySelectRef}
                data={allCity}
                name={'city'}
                onPress={handleCitySelect}
                isHeaderComponent={true}
                snapPoint={[300, '100%']}
            />
        </>
    );
};

export default AddNewAddress;

export const Styles = (error, address) => StyleSheet.create({
    flex: {
        flex: 1,
    },
    textInput: {
        borderWidth: 1,
        borderColor: error.first_name ? "#E43147" : "#DFDFDF",
        height: dpr(42),
        borderRadius: 2,
        fontSize: dpr(14),
        color: "#898989",
        fontFamily: "Roboto_500Medium",
        paddingHorizontal: 10,
        textAlign: I18nManager.isRTL ? "right" : "left",
    },
    firstNameInput: {
        width: (width - dpr(55)) / 2,
        height: dpr(42),
        marginRight: 15,
        borderColor: error.first_name ? "#E43147" : "#DFDFDF",
    },
    emailInput: {
        borderColor: error.email ? "#E43147" : "#DFDFDF",
    },
    phoneInput: {
        borderColor: error.phone ? '#E43147' : '#DFDFDF',
        marginTop: dpr(10),
        flexDirection: 'row',
        alignItems: 'center',
    },
    addressInput: {
        borderColor: error.address_1 ? '#E43147' : '#DFDFDF',
    },
    cityInput: {
        borderColor: error.city ? '#E43147' : '#DFDFDF',
        marginRight: dpr(15),
    },
    inputBorderColor: (error) => ({
        borderColor: error ? "#E43147" : "#DFDFDF",
    }),
    zipInput: {
        borderColor: error.zip ? '#E43147' : '#DFDFDF',
    },
    input: {
        width: (width - dpr(55)) / 2,
        height: dpr(42),
    },
    phoneInputContainer: {
        height: dpr(42),
        width: dpr("wf") - dpr(42),
    },
    homeRadioButtonContainer: {
        borderColor: error?.type_of_place
            ? '#E43147'
            : address?.type_of_place ===
                'home'
                ? '#2C2C2C'
                : '#DFDFDF',
    },
    homeRadioButtonText: {
        color: address.type_of_place === 'home' ? '#2C2C2C' : '#898989'
    },
    officeRadioButtonContainer: {
        borderColor: error.type_of_place
            ? '#E43147'
            : address.type_of_place ===
                'office'
                ? '#2C2C2C'
                : '#DFDFDF',
    },
    officeRadioButtonText: {
        color:
            address.type_of_place ===
                'office'
                ? '#2C2C2C'
                : '#898989',
    },
    codeText: {
        fontSize: dpr(13),
        color: "#898989",
        fontFamily: "Roboto_500Medium",
    },
    ml15: {
        marginLeft: 15,
    },
    textContainer: {
        paddingLeft: 0,
        paddingBottom: 0,
        paddingTop: 0,
        height: dpr(42),
        fontSize: dpr(13),
        backgroundColor: "#FFF",
    },
    textInputStyle: {
        borderColor: "#DFDFDF",
        paddingLeft: dpr(10),
        fontSize: dpr(13),
        paddingBottom: 0,
        paddingTop: 0,
        color: "#898989",
        fontFamily: "Roboto_500Medium",
        borderLeftWidth: I18nManager.isRTL ? 0 : 1,
        borderRightWidth: I18nManager.isRTL ? 1 : 0,
        textAlign: I18nManager.isRTL ? "right" : "left",
    },
});
